const axios = require("axios");
const sqlite3 = require("sqlite3").verbose();
const fs = require("fs");

const db = new sqlite3.Database("security-txt.db");

const request = async (url) => {
  let data;

  try {
    // TODO disable redirects
    // const response = await axios.get(url, { maxRedirects: 0 });
    const response = await axios.get(url);

    data = {
      status: response.status,
      contentType: response.headers["content-type"],
      data: response.data,
    };

    console.log(`[${response.status}] ${url}`);
  } catch (error) {
    data = {
      status:
        error.response && error.response.status ? error.response.status : null,
      contentType: null,
      data: null,
    };

    console.log(
      `[${
        error.response && error.response.status ? error.response.status : "ERR"
      }] ${url}`
    );
  }

  return data;
};

const save = async (data) => {
  await db.run(
    "INSERT INTO `results` (timestamp, domain, path, statusCode, headerContentType, contents) VALUES (?, ?, ?, ?, ?, ?)",
    data
  );
};

const crawl = async (domain) => {
  const timestamp = new Date().toISOString();

  // /.well-known/security.txt
  const wellKnownSecurity = `https://${domain}/.well-known/security.txt`;
  const wellKnownData = await request(wellKnownSecurity);

  await save([
    timestamp,
    domain,
    `/.well-known/security.txt`,
    wellKnownData.status,
    wellKnownData.contentType,
    wellKnownData.data,
  ]);

  /*
  // /security.txt
  const topLevelSecurity = `https://${domain}/security.txt`;
  const topLevelData = await request(topLevelSecurity);

  await save([
    timestamp,
    domain,
    `/security.txt`,
    topLevelData.status,
    topLevelData.contentType,
    topLevelData.data,
  ]);
  */
};

(async () => {
  // setup db
  db.serialize();
  db.run(
    "CREATE TABLE IF NOT EXISTS `results` (`id` INTEGER PRIMARY KEY AUTOINCREMENT, `timestamp` datetime, `domain` varchar(255), `path` varchar(255), `statusCode` varchar(255), `headerContentType` varchar(255), `contents` varchar(255));"
  );

  // load domain
  const domains = fs.readFileSync("domains.txt").toString().split("\n");
  // const domains = ["google.com"];

  // query all pages
  await Promise.all(domains.map(async (domain) => crawl(domain)));

  // close db
  db.close();
})();
